/*
 * Decompiled with CFR 0.152.
 */
package com.cottagesystems.jdiskhog;

import com.cottagesystems.jdiskhog.JDiskHogPanel;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class MyMouseListener
extends MouseAdapter {
    JTree jtree;
    JDiskHogPanel panel;
    TreePath context;

    MyMouseListener(JTree jtree, JDiskHogPanel panel) {
        this.jtree = jtree;
        this.panel = panel;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.context = this.jtree.getPathForLocation(e.getX(), e.getY());
            this.jtree.getSelectionModel().addSelectionPath(this.context);
            if (this.context != null) {
                this.showPopup(e);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.context = this.jtree.getPathForLocation(e.getX(), e.getY());
            this.jtree.getSelectionModel().addSelectionPath(this.context);
            if (this.context != null) {
                this.showPopup(e);
            }
        }
    }

    private synchronized void showPopup(MouseEvent e) {
        JPopupMenu popup = new JPopupMenu();
        JMenuItem mi = new JMenuItem(this.panel.getDeleteAction(this.jtree));
        mi.setToolTipText("Delete files or folders from the local cache");
        popup.add(mi);
        mi = new JMenuItem(this.panel.getPruneTreeAction(this.jtree));
        mi.setToolTipText("Delete empty folders from the local cache");
        popup.add(mi);
        mi = new JMenuItem(this.panel.getCopyToAction(this.jtree));
        mi.setToolTipText("Make a copy of files or folders to location outside of file cache.");
        popup.add(mi);
        mi = new JMenuItem(this.panel.getCopyClipboardAction(this.jtree));
        mi.setToolTipText("Copy the name to the system clipboard.");
        popup.add(mi);
        mi = new JMenuItem(this.panel.getLocalROCacheAction(this.jtree));
        mi.setToolTipText("Specify a local copy of the remote files, and use files from here before downloading.");
        popup.add(mi);
        this.panel.maybeAddGitPullAction(popup);
        popup.show(this.jtree, e.getX(), e.getY());
    }
}

